/*
 * TabWidget.h
 *
 *  Created on: 02.08.2011
 *      Author: stefan.detter
 */

#ifndef TABWIDGET_H_
#define TABWIDGET_H_

#include <QWidget>
#include <License.h>

class TabWidget : public QWidget
{
	Q_OBJECT

public:
	TabWidget( const QString& name, QWidget * parent = 0 );
	virtual ~TabWidget();

	const QString& 	name();
	bool 			isWorking();

	virtual void 	clearView();

	virtual bool 	hasExecutionCount();
	virtual uint 	executionCount();

signals:
	void working();
	void idle();

protected:
	void setWorking();
	void setIdle();

private:
	QString 	m_name;
	bool 		m_working;
};


class QrfeReaderInterface;
class QrfeTagInterface;


class ReaderTabWidget : public TabWidget
{
	Q_OBJECT
public:
	ReaderTabWidget( const QString& name, QWidget * parent = 0 ):TabWidget(name, parent){}
	virtual bool init(QrfeReaderInterface* reader) = 0;
	virtual void deinit() = 0;
	virtual void activated() = 0;
};

class TagTabWidget : public TabWidget
{
	Q_OBJECT
public:
	TagTabWidget( const QString& name, QWidget * parent = 0 ):TabWidget(name, parent){}
	virtual bool init(QrfeReaderInterface* reader, QrfeTagInterface* tag) = 0;
	virtual void deinit() = 0;
};


#endif /* TABWIDGET_H_ */
